﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultSystemPlugin.Controls.Strategy
{
    public interface IShellIconSizeStrategy
    {
        void Write(int i);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class ShellIconSizeDefaultStrategy : ICorrespondenceOS, IShellIconSizeStrategy
    {
        public ShellIconSizeDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
#if DEBUG              
                                            OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsVista_SP2,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "Shell Icon Size";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        public void Write(int i)
        {
            RegistryKey registryKey =
                Registry.CurrentUser.CreateSubKey(
                    @"Control Panel\Desktop\WindowMetrics");

            registryKey.SetValue(RegName, i);
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.CurrentUser.OpenSubKey(
                    @"Control Panel\Desktop\WindowMetrics");

            return new WFRegistry(@"HKEY_CURRENT_USER\Control Panel\Desktop\WindowMetrics", RegName,
                              registryKey.GetValue(RegName, 32), RegistryValueKind.DWord, RegOperation.KeyWrite);



        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

    }

    public class ShellIconSizeController
    {
        public ShellIconSizeController(ShellIconSize shellIconSize,
                                                         IShellIconSizeStrategy strategy)
        {
            ShellIconSize = shellIconSize;
            Strategy = strategy;
        }

        public ShellIconSize ShellIconSize { get; set; }
        public IShellIconSizeStrategy Strategy { get; set; }

        public void Read()
        {
            ShellIconSize.SetShellIconSizeValue(Convert.ToInt32(Strategy.Read().Value));
        }

        public void Write()
        {
            Strategy.Write(ShellIconSize.GetShellIconSizeValue());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}
